/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.client.screen.framework.widget;

import com.mojang.blaze3d.vertex.PoseStack;
import doggytalents.client.screen.framework.types.TextType;
import doggytalents.client.screen.framework.widget.FlatButton;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.FormattedCharSequence;

public class MultiLineFlatButton
extends FlatButton {
    private final int LINE_SPACING = 2;
    private final int PADDING_LEFT = 6;
    private List<FormattedCharSequence> lines;
    private TextType.Align align = TextType.Align.MIDDLE;

    public MultiLineFlatButton(int x, int y, int width, int height, int r_pad, Component text, FlatButton.OnPress onPress) {
        super(x, y, width, height, (Component)Component.m_237119_(), onPress);
        this.lines = this.font.m_92923_((FormattedText)text, width - r_pad);
    }

    public MultiLineFlatButton setTextAlign(TextType.Align align) {
        this.align = align;
        return this;
    }

    @Override
    public void m_87963_(GuiGraphics graphics, int mouseX, int mouseY, float pTicks) {
        if (!this.f_93623_) {
            return;
        }
        int cl = this.maskColor(this.buttonColor, this.f_93622_);
        graphics.m_280509_(this.m_252754_(), this.m_252907_(), this.m_252754_() + this.f_93618_, this.m_252907_() + this.f_93619_, cl);
        if (this.align == TextType.Align.LEFT) {
            this.drawLeft(graphics);
        } else if (this.align == TextType.Align.MIDDLE) {
            this.drawCentered(graphics);
        }
    }

    private void drawCentered(GuiGraphics graphics) {
        int mX = this.m_252754_() + this.f_93618_ / 2;
        int mY = this.m_252907_() + this.f_93619_ / 2;
        int lines_cnt = this.lines.size();
        Objects.requireNonNull(this.font);
        int text_height = lines_cnt * 9 + (lines_cnt - 1) * 2;
        int pTY = mY - text_height / 2;
        for (FormattedCharSequence line : this.lines) {
            int pTX = mX - this.font.m_92724_(line) / 2;
            graphics.m_280648_(this.font, line, pTX, pTY, -1);
            Objects.requireNonNull(this.font);
            pTY += 9 + 2;
        }
    }

    private void drawLeft(GuiGraphics graphics) {
        int mX = this.m_252754_() + this.f_93618_ / 2;
        int mY = this.m_252907_() + this.f_93619_ / 2;
        int lines_cnt = this.lines.size();
        Objects.requireNonNull(this.font);
        int text_height = lines_cnt * 9 + (lines_cnt - 1) * 2;
        int pTX = this.m_252754_() + 6;
        int pTY = mY - text_height / 2;
        for (FormattedCharSequence line : this.lines) {
            graphics.m_280648_(this.font, line, pTX, pTY, -1);
            Objects.requireNonNull(this.font);
            pTY += 9 + 2;
        }
    }

    private void drawRight(PoseStack stack) {
    }
}

